<?php
if (!isset($chat_id)) exit;

// 1) membership gate
if (!check_membership($chat_id)) {
    send_menu($chat_id, require_membership_text());
    return;
}

// 2) hard one-time rule: if any record exists (pending/success/failed/expired), block
if (has_trial($chat_id)) {
    send_text($chat_id, already_trial_text() . "\n\nبرای خرید اشتراک دائمی به سایت ما مراجعه کنید.");
    return;
}

// 3) place a PENDING lock immediately to prevent double-click spamming
save_trial($chat_id, 'pending', null, null, 'pending');

// 4) call panel
[$ok, $res] = create_trial_on_panel($chat_id);
if ($ok) {
    save_trial($chat_id, (string)$res['id'], (string)$res['uuid'], (string)$res['subscription'], 'success');
    send_text($chat_id, trial_created_text($res['subscription']));
} else {
    // keep the record as failed so user can't spam more than once (one-time policy)
    save_trial($chat_id, 'failed', null, null, 'failed');
    send_text($chat_id, panel_error_text());
}
