-- FINAL schema (includes 'pending' state)
CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  chat_id BIGINT UNIQUE,
  username VARCHAR(64),
  first_name VARCHAR(64),
  joined BOOLEAN DEFAULT 0,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS trials (
  id INT AUTO_INCREMENT PRIMARY KEY,
  chat_id BIGINT UNIQUE,
  panel_service_id VARCHAR(64),
  panel_service_uuid VARCHAR(128),
  subscription_link TEXT,
  status ENUM('pending','success','failed','expired') DEFAULT 'pending',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- If you already had an older table without 'pending', run:
-- ALTER TABLE trials MODIFY status ENUM('pending','success','failed','expired') DEFAULT 'pending';
